package com.example.sefinsa_app.controllers;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.provider.BaseColumns;
import android.util.Log;

import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Ruta;

import java.util.ArrayList;

public class RutaController {

    private final DatabaseHelper databaseHelper;

    private final String NOMBRE_TABLA = "rutas";

    public RutaController(Context contexto) {
        databaseHelper = new DatabaseHelper(contexto);
        SQLiteDatabase db = databaseHelper.getWritableDatabase();

        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(" +
                "id integer primary key autoincrement, " +
                "nombre_ruta text, " +
                "empleado_id int, " +
                "status int, " +
                "created_at text, " + "updated_at text)", NOMBRE_TABLA);

        db.execSQL(TABLE_SCHEMA);
    }

    public boolean tablaExiste() {

        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("select DISTINCT tbl_name from sqlite_master where tbl_name = '" + NOMBRE_TABLA+ "'", null);

        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.close();
                return true;
            }
            cursor.close();
        }
        return false;
    }


    public ArrayList<Poblacion> getPoblaciones(String ruta) {
        SQLiteDatabase db = databaseHelper.getReadableDatabase();

        String q = "SELECT * FROM poblaciones WHERE ruta_id = ?";
        Cursor cursor = db.rawQuery(q, new String[]{ruta});

        ArrayList<Poblacion> poblaciones = new ArrayList<>();

        if (cursor.moveToFirst()) {

            do {
                String id = cursor.getString(0);
                String nombre = cursor.getString(1);

                poblaciones.add(new Poblacion(id, nombre));
            } while (cursor.moveToNext());
        }
        return poblaciones;
    }

    public int eliminar(Ruta ruta) {

        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        String[] argumentos = {String.valueOf(ruta.getId())};
        return db.delete(NOMBRE_TABLA, "id = ?", argumentos);
    }

    public long nueva(Ruta ruta) {
        // writable porque vamos a insertar
        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("SELECT id from RUTAS where rutas.id = " + ruta.getId(), null);

        if(cursor.moveToFirst()){
            return 0;
        }
        else{
            ContentValues valoresParaInsertar = new ContentValues();
            valoresParaInsertar.put("id", ruta.getId());
            valoresParaInsertar.put("nombre_ruta", ruta.getNombre_ruta());
            valoresParaInsertar.put("empleado_id", ruta.getEmpleado_id());
            valoresParaInsertar.put("status", ruta.getStatus());
            valoresParaInsertar.put("created_at", ruta.getCreated_at());
            valoresParaInsertar.put("updated_at", ruta.getUpdated_at());
            return db.insert(NOMBRE_TABLA, null, valoresParaInsertar);
        }

    }

    public void truncate(){
        SQLiteDatabase db = databaseHelper.getWritableDatabase();

        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(" +
                "id integer primary key autoincrement, " +
                "nombre_ruta text, " +
                "empleado_id int, " +
                "status int, " +
                "created_at text, " + "updated_at text)", NOMBRE_TABLA);

        db.execSQL("DROP TABLE IF EXISTS " + NOMBRE_TABLA);

        db.execSQL(TABLE_SCHEMA);

        Log.d("TRUNCATE",NOMBRE_TABLA);
    }

    public ArrayList<Ruta> obtener() {
        ArrayList<Ruta> rutas = new ArrayList<>();
        // readable porque no vamos a modificar, solamente leer
        SQLiteDatabase db = databaseHelper.getReadableDatabase();
        // SELECT nombre, edad, id
        String[] columnasAConsultar = {"id", "nombre_ruta", "empleado_id", "status", "created_at", "updated_at"};
        Cursor cursor = db.query(
                "rutas",
                columnasAConsultar,
                null,
                null,
                null,
                null,
                "id DESC"
        );

        if (cursor == null) {
        /*
            Salimos aquí porque hubo un error, regresar
            lista vacía
            */
            return rutas;

        }
        // Si no hay datos, igualmente regresamos la lista vacía
        if (!cursor.moveToFirst()) return rutas;

        // En caso de que sí haya, iteramos y vamos agregando los
        // datos a la lista de mascotas
        do {
            // El 0 es el número de la columna, como seleccionamos
            // nombre, edad,id entonces el nombre es 0, edad 1 e id es 2
            String id = cursor.getString(0);
            String nombre_ruta = cursor.getString(1);
            String empleado_id = cursor.getString(2);
            String status = cursor.getString(3);
            String created_at = cursor.getString(4);
            String updated_at = cursor.getString(5);

            Ruta rutaObtenidaDeBD = new Ruta(id, nombre_ruta, empleado_id, status, created_at, updated_at);
            rutas.add(rutaObtenidaDeBD);
        } while (cursor.moveToNext());

        // Fin del ciclo. Cerramos cursor y regresamos la lista de mascotas :)
        cursor.close();
        return rutas;
    }

    public ArrayList<Ruta> getRutas(String rid) {
        SQLiteDatabase db = databaseHelper.getReadableDatabase();
        String q = "SELECT * FROM rutas WHERE id = ?";
        Cursor cursor = db.rawQuery(q, new String[]{rid});
        ArrayList<Ruta> rutas = new ArrayList<>();

        if (cursor.moveToFirst()) {
            do {
                String id = cursor.getString(0);
                String nombre = cursor.getString(1);
                String empleado = cursor.getString(2);
                String status = cursor.getString(3);
                String ca = cursor.getString(4);
                String ua = cursor.getString(5);

                rutas.add(new Ruta(
                        id,
                        nombre,
                        empleado,
                        status,
                        ca,
                        ua
                ));
            } while (cursor.moveToNext());
        }
        return rutas;
    }

    public ArrayList<Ruta> getRutas() {
        SQLiteDatabase db = databaseHelper.getReadableDatabase();
        String q = "SELECT * FROM rutas";
        Cursor cursor = db.rawQuery(q, new String[]{});
        ArrayList<Ruta> rutas = new ArrayList<>();

        if (cursor.moveToFirst()) {
            do {
                String id = cursor.getString(0);
                String nombre = cursor.getString(1);

                rutas.add(new Ruta(
                        id,
                        nombre
                ));
            } while (cursor.moveToNext());
        }
        return rutas;
    }

    public String getNombreRuta(String rid) {
        SQLiteDatabase db = databaseHelper.getReadableDatabase();
        String q = "SELECT nombre_ruta FROM rutas WHERE id = ?";
        Cursor cursor = db.rawQuery(q, new String[]{rid});

        if (cursor.moveToFirst()) {
            return cursor.getString(0);
        }
        return null;
    }
}
